/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

#define ITERS 40
#define M_PI 3.1415926535897932384626433832795

void main ( void )
{
  vec2 p = vec2(gl_FragCoord.x / iResolution.x,
                gl_FragCoord.y / iResolution.y);
  float z = fract(0.005 * iGlobalTime);
  int acc = 0;
  float trig = (cos(6. * M_PI * z) + 1.) / 2.;
  float a = mix(2.5, 3.8, trig) + p.x * mix(1.5, 0.2, trig);
  
  float SC = mix(1., 3., trig);
  float OFF = mix(0., 1., trig);
  for (int i = 0; i < ITERS; i++) {
    float zz = SC * z - OFF;
    acc += (zz > p.y && zz <= p.y + 1. / iResolution.y) ? 1 : 0;
    z = a * z * (1.-z);
  }
  float iters = float(ITERS);
  float g = 60. * float(acc) / iters;

  gl_FragColor = vec4(1. - g, 1. - g /6., 1. - g / 10.,1.);

}
